with
  text_io,
  ada.integer_text_io,
  ada.long_float_text_io,
  ada.numerics.long_elementary_functions;

procedure hexahedron is

  edge : array (integer range 1 .. 12, integer range 1 .. 2) of integer;
  node : array (integer range 1 .. 8, integer range 1 .. 3) of long_float;

  procedure initia is

    use
      ada.numerics.long_elementary_functions;

    c1,c2 : long_float;

  begin
    c1 := sqrt(2.0) / sqrt(3.0);
    c2 := 1.0 / sqrt(3.0);

    -- initiate node
    node(1,1) := -c1;
    node(1,2) := 0.0;
    node(1,3) := -c2;

    node(2,1) := 0.0;
    node(2,2) := -c1;
    node(2,3) := -c2;

    node(3,1) := c1;
    node(3,2) := 0.0;
    node(3,3) := -c2;

    node(4,1) := 0.0;
    node(4,2) := c1;
    node(4,3) := -c2;

    node(5,1) := -c1;
    node(5,2) := 0.0;
    node(5,3) := c2;

    node(6,1) := 0.0;
    node(6,2) := -c1;
    node(6,3) := c2;

    node(7,1) := c1;
    node(7,2) := 0.0;
    node(7,3) := c2;

    node(8,1) := 0.0;
    node(8,2) := c1;
    node(8,3) := c2;

    -- initiate edge
    edge(1,1) := 1;
    edge(1,2) := 2;

    edge(2,1) := 2;
    edge(2,2) := 3;

    edge(3,1) := 3;
    edge(3,2) := 4;

    edge(4,1) := 4;
    edge(4,2) := 1;

    edge(5,1) := 5;
    edge(5,2) := 6;

    edge(6,1) := 6;
    edge(6,2) := 7;

    edge(7,1) := 7;
    edge(7,2) := 8;

    edge(8,1) := 8;
    edge(8,2) := 5;

    edge(9,1) := 1;
    edge(9,2) := 5;

    edge(10,1) := 2;
    edge(10,2) := 6;

    edge(11,1) := 3;
    edge(11,2) := 7;

    edge(12,1) := 4;
    edge(12,2) := 8;
  end initia;

  procedure input is

    use
      text_io,
      ada.integer_text_io,
      ada.long_float_text_io;

    maxls,maxminor,maxlist,h    : integer;
    lstol,mntol,mnref,mu10,mu01 : long_float;
    io                          : file_type;

  begin
    create(io, out_file, "input.txt");

    -- solution parameters
    lstol := 1.0E-01;
    maxls := 20;
    mntol := 1.0E-05;
    mnref := 1.0;
    maxminor := 240;
    maxlist := 3;

    put(io,"        lstol     maxls             mntol             mnref  maxminor   maxlist");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,lstol,2,6,3);
    put(io,"     ");
    put(io,maxls,5);
    put(io,"     ");
    put(io,mntol,2,6,3);
    put(io,"     ");
    put(io,mnref,2,6,3);
    put(io,"     ");
    put(io,maxminor,5);
    put(io,"     ");
    put(io,maxlist,5);
    new_line(io);

    -- material parameters
    h := 2;
    mu10 := 0.3750;
    mu01 := -0.1250;

    new_line(io);
    new_line(io);
    put(io,"    h              mu10              mu01");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,h,5);
    put(io,"     ");
    put(io,mu10,2,6,3);
    put(io,"     ");
    put(io,mu01,2,6,3);
    new_line(io);
    
    -- node coordinates
    new_line(io);
    new_line(io);
    put(io," node           coord x           coord y           coord z");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,"    8");
    new_line(io);

    new_line(io);
    for glob in 1 .. 8 loop
      put(io,glob,5);
      for axis in 1 .. 3 loop      
        put(io,"     ");
        put(io,node(glob,axis),2,6,3);
      end loop;
      new_line(io);
    end loop;

    -- elements
    new_line(io);
    new_line(io);
    put(io," elem      node      node              area");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,"   12");
    new_line(io);

    new_line(io);
    for e in 1 .. 12 loop
      put(io,e,5);
      for loc in 1 .. 2 loop
        put(io,"     ");
        put(io,edge(e,loc),5);
      end loop;
      put(io,"      1.000000E+00");
      new_line(io);
    end loop;

    -- known displacements
    new_line(io);
    new_line(io);
    put(io," node      axis             displ");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,"   12");
    new_line(io);

    new_line(io);

    put(io,"    1         2      0.000000E+00");
    new_line(io);
    put(io,"    1         3      0.000000E+00");
    new_line(io);
    put(io,"    3         2      0.000000E+00");
    new_line(io);
    put(io,"    3         3      0.000000E+00");
    new_line(io);

    put(io,"    2         1      0.000000E+00");
    new_line(io);
    put(io,"    2         3      0.000000E+00");
    new_line(io);
    put(io,"    4         1      0.000000E+00");
    new_line(io);
    put(io,"    4         3      0.000000E+00");
    new_line(io);

    put(io,"    5         2      0.000000E+00");
    new_line(io);
    put(io,"    7         2      0.000000E+00");
    new_line(io);

    put(io,"    6         1      0.000000E+00");
    new_line(io);
    put(io,"    8         1      0.000000E+00");
    new_line(io);

    -- force
    new_line(io);
    new_line(io);
    put(io," node      axis             force");
    new_line(io);
    put(io,":");
    new_line(io);
    put(io,"   16");
    new_line(io);

    new_line(io);
    for glob in 1 .. 8 loop
      for axis in 1 .. 3 loop    
        if node(glob,axis) /= 0.0 then
          put(io,glob,5);
          put(io,"     ");
          put(io,axis,5);
          put(io,"     ");
          put(io,node(glob,axis),2,6,3);
          new_line(io);
        end if;
      end loop;
    end loop;
    close(io);
  end input;

  procedure autocad is

    use
      text_io,
      ada.long_float_text_io;

    glob : integer;
    io   : file_type;

  begin
    create(io, out_file, "hexahedron.scr");

    -- set running object snap mode to NONE
    put(io,"osmode 0");
    new_line(io);

    -- elements 1
    put(io,"layer make hexahedron ");
    new_line(io);

    for e in 1 .. 12 loop
      put(io,"3dpoly ");
      for loc in 1 .. 2 loop
        glob := edge(e,loc);
        put(io,node(glob,1),1,8,3);
        put(io,",");
        put(io,node(glob,2),1,8,3);
        put(io,",");
        put(io,node(glob,3),1,8,3);
        put(io," ");
      end loop;
      new_line(io);
    end loop;

    put(io,"layer set 0 ");
    new_line(io);

    put(io,"zoom ext ext");
    new_line(io);

    close(io);
  end autocad;

begin
  initia;
  
  input;
  
  autocad;
end hexahedron;
